CREATE SCHEMA ZamowieniaZmiana;

SET search_path TO ZamowieniaZmiana;

CREATE TABLE Kategorie (
	IDKategorii serial PRIMARY KEY ,
	OpisKategorii varchar (75) NULL 
	);

CREATE TABLE Klienci (
	IDKlienta serial PRIMARY KEY ,
	ImieKlienta varchar (25) NULL ,
	NazwiskoKlienta varchar (25) NULL ,
	AdresKlienta varchar (50) NULL ,
	MiastoKlienta varchar (30) NULL ,
	StanZamKlienta varchar (2) NULL ,
	KodPocztowyKlienta varchar (10) NULL ,
	NumKierKlienta smallint NULL DEFAULT 0 ,
	TelefonKlienta varchar (8) NULL 
	);

CREATE TABLE Pracownicy (
	IDPracownika serial PRIMARY KEY ,
	ImiePracownika varchar (25) NULL ,
	NazwiskoPracownika varchar (25) NULL ,
	AdresPracownika varchar (50) NULL ,
	MiastoPracownika varchar (30) NULL ,
	StanZamPracownika varchar (2) NULL ,
	KodPocztowyPracownika varchar (10) NULL ,
	NumKierunkPracownika smallint NULL DEFAULT 0 ,
	TelefonPracownika varchar (8) NULL 
	);

CREATE TABLE Dane_zamowien (
	NumerZamowienia int NOT NULL DEFAULT 0 ,
	NumerProduktu int NOT NULL DEFAULT 0 ,
	CenaZakupu decimal (15,2) NULL DEFAULT 0 ,
	ZamowionaIlosc smallint NULL DEFAULT 0  
	);

CREATE TABLE Dane_zamowien_archiwum (
	NumerZamowienia int NOT NULL DEFAULT 0 ,
	NumerProduktu int NOT NULL DEFAULT 0 ,
	CenaZakupu decimal (15,2) NULL DEFAULT 0 ,
	ZamowionaIlosc smallint NULL DEFAULT 0 
);

CREATE TABLE Zamowienia (
	NumerZamowienia serial PRIMARY KEY ,
	DataZamowienia date NULL ,
	DataWysylki date NULL ,
	IDKlienta int NULL DEFAULT 0 ,
	IDPracownika int NULL DEFAULT 0 ,
	WartoscCalkowita decimal (15,2) NULL DEFAULT 0 
	);

CREATE TABLE Zamowienia_archiwum (
	NumerZamowienia int NOT NULL PRIMARY KEY DEFAULT 0 ,
	DataZamowienia date NULL ,
	DataWysylki date NULL ,
	IDKlienta int NULL DEFAULT 0 ,
	IDPracownika int NULL DEFAULT 0 ,
	WartoscCalkowita decimal (15,2) NULL DEFAULT 0 
	);


CREATE TABLE Dostawcy_produktow (
	NumerProduktu int NOT NULL DEFAULT 0 ,
	IDDostawcy int NOT NULL DEFAULT 0 ,
	CenaHurtowa decimal (15,2) NULL DEFAULT 0 ,
	TerminDostarczenia smallint NULL DEFAULT 0 
	);

CREATE TABLE Produkty (
	NumerProduktu serial PRIMARY KEY ,
	NazwaProduktu varchar (50) NULL ,
	OpisProduktu varchar (100) NULL ,
	CenaDetaliczna decimal (15,2) NULL DEFAULT 0 ,
	StanMagazynowy smallint NULL DEFAULT 0 ,
	IDKategorii int NULL DEFAULT 0 
	);

CREATE TABLE Dostawcy (
	IDDostawcy serial PRIMARY KEY ,
	NazwaDostawcy varchar (25) NULL ,
	AdresDostawcy varchar (50) NULL ,
	MiastoDostawcy varchar (30) NULL ,
	StanSiedzDostawcy varchar (2) NULL ,
	KodPocztowyDostawcy varchar (10) NULL ,
	TelefonDostawcy varchar (15) NULL ,
	FaxDostawcy varchar (15) NULL ,
	StronaInterDostawcy text NULL ,
	EmailDostawcy varchar (50) NULL
	);

CREATE  INDEX NumKierKlienta ON Klienci(NumKierKlienta);

CREATE  INDEX KodPocztowyKlienta ON Klienci(KodPocztowyKlienta);

CREATE  INDEX NumKierunkPracownika ON Pracownicy(NumKierunkPracownika);

CREATE  INDEX KodPocztowyPracownika ON Pracownicy(KodPocztowyPracownika);

ALTER TABLE Dane_zamowien 
	ADD CONSTRAINT Dane_zamowien_PK PRIMARY KEY 
	(
		NumerZamowienia, 
		NumerProduktu
	);

CREATE  INDEX ZamowieniaDaneZamowien ON Dane_zamowien(NumerZamowienia);

CREATE  INDEX ProduktyDaneZamowien ON Dane_zamowien(NumerProduktu);

ALTER TABLE Dane_zamowien_archiwum 
	ADD CONSTRAINT Dane_zamowien_archiwum_PK PRIMARY KEY 
	(
		NumerZamowienia, 
		NumerProduktu
	); 

CREATE  INDEX Zamowienia_archiwumDane_zamowien_archiwum ON Dane_zamowien_archiwum(NumerZamowienia);

CREATE  INDEX O_IDKlienta ON Zamowienia(IDKlienta);

CREATE  INDEX O_IDPracownika ON Zamowienia(IDPracownika);

CREATE  INDEX OA_IDKlienta ON Zamowienia_archiwum(IDKlienta);

CREATE  INDEX OA_IDPracownika ON Zamowienia_archiwum(IDPracownika);

ALTER TABLE Dostawcy_produktow 
	ADD CONSTRAINT Dostawcy_produktow_PK PRIMARY KEY 
	(
		NumerProduktu, 
		IDDostawcy
	);

CREATE  INDEX ProduktyDostawcyProduktow ON Dostawcy_produktow(NumerProduktu);

CREATE  INDEX IDDostawcy ON Dostawcy_produktow(IDDostawcy);

CREATE  INDEX IDKategorii ON Produkty(IDKategorii);

CREATE  INDEX KodPocztowyDostawcy ON Dostawcy(KodPocztowyDostawcy);

ALTER TABLE Dane_zamowien 
	ADD CONSTRAINT Dane_zamowien_FK00 FOREIGN KEY 
	(
		NumerZamowienia
	) REFERENCES Zamowienia (
		NumerZamowienia
	),
	ADD CONSTRAINT Dane_zamowien_FK01 FOREIGN KEY 
	(
		NumerProduktu
	) REFERENCES Produkty (
		NumerProduktu
	);

ALTER TABLE Dane_zamowien_archiwum 
	ADD CONSTRAINT Dane_zamowien_archiwum_FK00 FOREIGN KEY 
	(
		NumerZamowienia
	) REFERENCES Zamowienia_archiwum (
		NumerZamowienia
	);

ALTER TABLE Zamowienia 
	ADD CONSTRAINT Zamowienia_FK00 FOREIGN KEY 
	(
		IDKlienta
	) REFERENCES Klienci (
		IDKlienta
	),
	ADD CONSTRAINT Zamowienia_FK01 FOREIGN KEY 
	(
		IDPracownika
	) REFERENCES Pracownicy (
		IDPracownika
	);

ALTER TABLE Dostawcy_produktow 
	ADD CONSTRAINT Dostawcy_produktow_FK00 FOREIGN KEY 
	(
		NumerProduktu
	) REFERENCES Produkty (
		NumerProduktu
	),
	ADD CONSTRAINT Dostawcy_produktow_FK01 FOREIGN KEY 
	(
		IDDostawcy
	) REFERENCES Dostawcy (
		IDDostawcy
	);

ALTER TABLE Produkty 
	ADD CONSTRAINT Produkty_FK00 FOREIGN KEY 
	(
		IDKategorii
	) REFERENCES Kategorie (
		IDKategorii
	);